﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;

// Summary
//		* Bottom item

namespace Game
{
	/*
		Bottom item의 종류

		Normal: 기본
		Damage: Player에게 damage을 입힌다.
		Disappear: 일정 animation 후에 사라진다.
		SlideLeft: Player를 좌측방향으로 이동시킨다.
		SlideRight: Player에게 우측방향으로 이동시킨다.
		Destory: 파괴.
 	*/
	public enum BottomType
	{
		None,
		Normal,
		Damage,
		Disappear,
		SlideLeft,
		SlideRight,
		Destroy
	}

	/*
		Bottom item
 	*/
	public class BottomItem : MonoBehaviour
	{

		public delegate void onBottomEventEnter (BottomItem item);

		public delegate void onBottomEventStay (BottomItem item);

		public delegate void onBottomEventExit (BottomItem item);

		public event onBottomEventEnter bottomEventEnter;
		public event onBottomEventStay bottomEventStay;
		public event onBottomEventExit bottomEventExit;

		public float Speed	= 0f;
		public float DisappearTime;
		public BottomType m_BottomType	= BottomType.None;
		public bool DidEvent	= false;
	
		float enterTime;
		bool didEnter;
		bool didExit;

		bool isPause	= false;

		// Use this for initialization
		void OnDestroy ()
		{
			bottomEventEnter = null;
			bottomEventStay = null;
			bottomEventExit = null;
		}

		void Start ()
		{
			enterTime	= 0f;
		}
	
		// Update is called once per frame
		void Update ()
		{
			if (isPause == false) {
				Move ();

				if (didEnter == true
				   && m_BottomType == BottomType.Disappear) {
					enterTime += Time.deltaTime;

					if (enterTime >= DisappearTime) {		
						DestroyImmediate (this.gameObject);
					}
				}
			}
		}

		void OnCollisionEnter (Collision other)
		{
			if (other.gameObject.tag == "Player") {
				didEnter	= true;

				if (bottomEventEnter != null) {
					bottomEventEnter (this);
				}
			}
		}

		void OnCollisionStay (Collision other)
		{
			if (other.gameObject.tag == "Player") {
				if (bottomEventStay != null) {
					bottomEventStay (this);
				}
			}
		}

		void OnCollisionExit (Collision other)
		{
			if (other.gameObject.tag == "Player") {
				didExit	= true;

				if (bottomEventExit != null) {
					bottomEventExit (this);
				}
			}
		}

		// MARK: - Public
		/*
			Bottom item의 type을 얻어온다.

			@return BottomType
	 	*/
		public BottomType GetBottomType ()
		{
			return m_BottomType;
		}

		// MARK: - Private
		/*
			Bottom item을 움직인다.
	 	*/
		void Move ()
		{
			Vector3 mov = new Vector3 (0, Speed * Time.deltaTime, 0);

			transform.position += mov;
		}

		/*
			Bottom item의 이동을 정지한다.
	 	*/
		void Pause ()
		{
			isPause	= true;
		}

		/*
			Bottom item의 이동을 재개한다.
	 	*/
		void Resume ()
		{
			isPause = false;
		}
	}
}
